(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, italic, e6,  14, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, bold, L-5,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, B65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, l34, w282, h287,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	paletteColors = 128; automaticGrouping; currentKernel; 
]
:[font = section; inactive; preserveAspect; startGroup]
Initializations
:[font = input; initialization; preserveAspect; endGroup]
*)
<<Geometry`Rotations`
<<Ring`
<<Graphics`Polyhedra`
<<Graphics`Shapes`
<<NumberTheory`Recognize`
<<Graphics`Animation`
ActionOn[obj_,g_]:=
 obj/.{{a_,b_,c_}/;And@@NumberQ/@{a,b,c}:>g.{a,b,c}};
ActionOn::usage="ActionOn[obj,g] is the 3D-graphics object obtained
when rotation matrix g acts on 3D-graphics object obj.  This is accomplished
by multiplying every triple of numbers appearing in obj by g.";
disp=Show[Graphics3D[#],PlotRange->{{-2,2},{-2,2},{-2,2}}]& ;
compare=Show[GraphicsArray[
         {Graphics3D[#1,PlotRange->{{-2,2},{-2,2},{-2,2}}],
          Graphics3D[ActionOn[#1,#2],PlotRange->{{-2,2},{-2,2},{-2,2}}]}]]& ;
compare::usage="compare[obj,g] displays the 3D-graphics objects
obj and ActionOn[obj,g] side by side.";
exact=If[Abs[#]<=0.00000001,
         0,
         ((x=#)//Recognize[x,3,t]&//Solve[#==0,t]&//(t/.#)&//
           Select[#,(Abs[x-N[#]]<=0.000001)&]&//First)]&;
exact::usage="exact[x_Real] converts x to an exact number involving 
integers and roots (square and cube roots only).";


(*
:[font = section; inactive; preserveAspect; startGroup]
Goal
:[font = text; inactive; preserveAspect; endGroup]
To identify the rotation groups of polyhedra and to explore how a limited number of faces together with the rotational group can be used to represent a polyhedron.
:[font = section; inactive; preserveAspect; startGroup]
Prerequisite
:[font = text; inactive; preserveAspect; endGroup]
Familiarity with Euler angles (see Rotations Lab Appendix for a reveiw) and group actions.
:[font = section; inactive; preserveAspect; startGroup]
Example - the Tetrahedron
:[font = text; inactive; preserveAspect]
Consider the tetrahedron.
:[font = input; initialization; preserveAspect]
*)
object=Tetrahedron[];
(*
:[font = input; preserveAspect; startGroup]
object//disp
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
Graphics3D["<<>>"]
;[o]
-Graphics3D-
:[font = text; inactive; preserveAspect]
We will be examining certain rotation matrices that act on graphics objects like the Tetrahedron.  The function ActionOn will be used extensively in this notebook.
;[s]
3:0,0;112,1;120,0;164,-1;
2:2,13,9,Times,0,12,0,0,0;1,13,10,Courier,1,12,0,0,0;
:[font = input; preserveAspect; startGroup]
?ActionOn
:[font = print; inactive; preserveAspect; endGroup]
ActionOn[obj,g] the the 3D-graphics object obtained when rotation matrix g acts on 3D-graphics
  object obj.  This accomplished by multiplying every triple of numbers appearing in obj by g.
:[font = text; inactive; preserveAspect]
We will want to consider the rotation that make up the so-called rotational group of tetrahedron, the ones that result in an tetrahedron that occupies the same space as the original object.   We can use the fuction compare to visually confirm whether a rotation is in the rotation group.
;[s]
3:0,0;215,1;222,0;288,-1;
2:2,13,9,Times,0,12,0,0,0;1,13,10,Courier,1,12,0,0,0;
:[font = input; preserveAspect; startGroup]
?compare
:[font = print; inactive; preserveAspect; endGroup]
compare[obj,g] displays the 3D-graphics objects obj and ActionOn[obj,g] side by side.
:[font = text; inactive; preserveAspect]
Here is an example of a rotation that we won't want to consider.  
;[s]
3:0,0;41,1;46,0;67,-1;
2:2,13,9,Times,0,12,0,0,0;1,13,9,Times,4,12,0,0,0;
:[font = input; preserveAspect; startGroup]
compare[object,RotationMatrix3D[Pi/6,Pi/4,Pi/8]]
:[font = output; output; inactive; preserveAspect; endGroup]
GraphicsArray["<<>>"]
;[o]
-GraphicsArray-
:[font = text; inactive; preserveAspect]
One example of an element in the rotational group of this tetrahedron is RotationMatrix3D[2Pi/3,0,0].  The specific Euler angles that describe this matrix are dependent on the position of the tetrahedron.  One of its faces lies on a plane that is parallel to the x-y plane and so a 2/3 rotation about the z-axis is in the rotation group.  Also, it's important to note that the tetrahedron needs to be centered about the origin.  All polyhedra in the standard Mathematica  package Polyhedra.m are centered about the origin.
;[s]
5:0,0;73,1;100,0;460,2;471,0;524,-1;
3:3,13,9,Times,0,12,0,0,0;1,12,9,Courier,1,10,0,0,0;1,13,9,Times,2,12,0,0,0;
:[font = input; preserveAspect; startGroup]
r1=RotationMatrix3D[2Pi/3,0,0];r1//MatrixForm

:[font = output; output; inactive; preserveAspect; endGroup]
MatrixForm[{{-1/2, 3^(1/2)/2, 0}, {-3^(1/2)/2, -1/2, 0}, {0, 0, 1}}]
;[o]
  1        Sqrt[3]
-(-)       -------
  2           2       0

-Sqrt[3]     1
--------   -(-)
   2         2        0



0          0          1
:[font = input; preserveAspect; startGroup]
compare[object,r1]
:[font = output; output; inactive; preserveAspect; endGroup]
GraphicsArray["<<>>"]
;[o]
-GraphicsArray-
:[font = text; inactive; preserveAspect]
It isn't too difficult to identify r1 as a member of the rotational group.  But how would we identify more complicated rotations?  One way is by multiplying rotations.  Given any set of rotations, we can generate a group.
;[s]
3:0,0;35,1;37,0;222,-1;
2:2,13,9,Times,0,12,0,0,0;1,13,10,Courier,1,12,0,0,0;
:[font = input; preserveAspect; startGroup]
g1=GenerateGroupoid[{r1},Simplify[#1.#2]&]
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
Groupoid[{{{-1/2, -3^(1/2)/2, 0}, {3^(1/2)/2, -1/2, 0}, {0, 0, 1}}, 
 {{-1/2, 3^(1/2)/2, 0}, {-3^(1/2)/2, -1/2, 0}, {0, 0, 1}}, {{1, 0, 0}, {0, 1, 0}, {0, 0, 1}}},
 Simplify[#1 . #2] & ]
;[o]
              1   -Sqrt[3]       Sqrt[3]    1
Groupoid[{{{-(-), --------, 0}, {-------, -(-), 0}, {0, 0, 1}}, 
              2      2              2       2
     1   Sqrt[3]       -Sqrt[3]    1
 {{-(-), -------, 0}, {--------, -(-), 0}, {0, 0, 1}}, {{1, 0, 0}, {0, 1, 0}, {0, 0, 1}}}, 
     2      2             2        2
 Simplify[#1 . #2] & ]
:[font = input; preserveAspect; startGroup]
Order[g1]
:[font = output; output; inactive; preserveAspect; endGroup]
3
;[o]
3
:[font = text; inactive; preserveAspect]
This is a cyclic subgroup of order three, not all of the group of rotations. 

We can count the number of elements in the rotational group by considering the various final positions that any single fixed face of the tetrahedron could occupy.  Since there are four identical triangular faces and each face can be oriented in three ways, there are 12 rotations of the tetrahedron.   It may or may not be obvious to you what other rotation matrices are in the desired group.  At this point, we will outline a process to find these matrices systematically.
:[font = input; preserveAspect; startGroup]
Graphics3D[
  {object,
   Map[Text[ToString[#],Vertices[Tetrahedron][[#]]]&,
        Range[1,Length[Vertices[Tetrahedron]]]]
   }]//
WireFrame//Show[#,DefaultFont->{"Times",24}]&
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
Graphics3D["<<>>"]
;[o]
-Graphics3D-
:[font = text; inactive; preserveAspect]
The first rotation (r1) that we identified maps the (ordered) face {1, 3, 4} into the face {1,  2,  3} and by applying it again into {1, 4, 2}.  Now suppose that we want to map {1, 3, 4} into {4, 3, 2}.  Let R be the unknown matrix.
;[s]
5:0,0;20,1;22,0;208,1;209,0;233,-1;
2:3,13,9,Times,0,12,0,0,0;2,13,10,Courier,1,12,0,0,0;
:[font = input; preserveAspect; startGroup]
R=Array[r,{3,3}]
:[font = output; output; inactive; preserveAspect; endGroup]
{{r[1, 1], r[1, 2], r[1, 3]}, {r[2, 1], r[2, 2], r[2, 3]}, {r[3, 1], r[3, 2], r[3, 3]}}
;[o]
{{r[1, 1], r[1, 2], r[1, 3]}, {r[2, 1], r[2, 2], r[2, 3]}, {r[3, 1], r[3, 2], r[3, 3]}}
:[font = text; inactive; preserveAspect]
Before setting up a system of equations to solve for the rotation matrix, we need to take the vertex coordinates given in the Mathematica  Polyhedra package and make them exact.  For this we use the function exact.
;[s]
5:0,0;126,1;137,0;208,2;213,0;215,-1;
3:3,13,9,Times,0,12,0,0,0;1,13,9,Times,2,12,0,0,0;1,13,10,Courier,1,12,0,0,0;
:[font = input; preserveAspect; startGroup]
?exact
:[font = print; inactive; preserveAspect; endGroup]
exact[x_Real] converts x to an exact number involving   integers and roots (square and cube
  roots only).
:[font = text; inactive; preserveAspect]
Here are the vertices given in the package.
:[font = input; preserveAspect; startGroup]
Vertices[Tetrahedron]
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
{{0, 0, 1.732050807568877}, {0, 1.632993161855452, -0.5773502691896259}, 
 {-1.414213562373095, -0.816496580927726, -0.5773502691896259}, 
 {1.414213562373095, -0.816496580927726, -0.5773502691896259}}
;[o]
{{0, 0, 1.73205}, {0, 1.63299, -0.57735}, {-1.41421, -0.816497, -0.57735}, 
 {1.41421, -0.816497, -0.57735}}
:[font = text; inactive; preserveAspect]
The following are exact values
:[font = input; preserveAspect; startGroup]
evertices=Map[exact,Vertices[Tetrahedron],{2}]
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
{{0, 0, 3^(1/2)}, {0, 2*(2/3)^(1/2), -3^(-1/2)}, {-2^(1/2), -(2/3)^(1/2), -3^(-1/2)}, 
 {2^(1/2), -(2/3)^(1/2), -3^(-1/2)}}
;[o]
                             2        1                        2        1
{{0, 0, Sqrt[3]}, {0, 2 Sqrt[-], -(-------)}, {-Sqrt[2], -Sqrt[-], -(-------)}, 
                             3     Sqrt[3]                     3     Sqrt[3]
                 2        1
 {Sqrt[2], -Sqrt[-], -(-------)}}
                 3     Sqrt[3]
:[font = text; inactive; preserveAspect]
Although a system can be generated more efficiently, we write it out here a bit more descriptively.
:[font = input; preserveAspect; startGroup]
sys={R.evertices[[1]]==evertices[[4]]   (* vertex 1 maps to vertex 4 *),
     R.evertices[[3]]==evertices[[3]]   (* vertex 3 maps to vertex 3 *),
     R.evertices[[4]]==evertices[[2]]   (* vertex 4 maps to vertex 2 *)}
     
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
{{3^(1/2)*r[1, 3], 3^(1/2)*r[2, 3], 3^(1/2)*r[3, 3]} == {2^(1/2), -(2/3)^(1/2), -3^(-1/2)}, 
 {-(2^(1/2)*r[1, 1]) - (2/3)^(1/2)*r[1, 2] - r[1, 3]/3^(1/2), 
 -(2^(1/2)*r[2, 1]) - (2/3)^(1/2)*r[2, 2] - r[2, 3]/3^(1/2), 
 -(2^(1/2)*r[3, 1]) - (2/3)^(1/2)*r[3, 2] - r[3, 3]/3^(1/2)} == 
 {-2^(1/2), -(2/3)^(1/2), -3^(-1/2)}, 
 {2^(1/2)*r[1, 1] - (2/3)^(1/2)*r[1, 2] - r[1, 3]/3^(1/2), 
 2^(1/2)*r[2, 1] - (2/3)^(1/2)*r[2, 2] - r[2, 3]/3^(1/2), 
 2^(1/2)*r[3, 1] - (2/3)^(1/2)*r[3, 2] - r[3, 3]/3^(1/2)} == {0, 2*(2/3)^(1/2), -3^(-1/2)}}
;[o]
                                                                        2        1
{{Sqrt[3] r[1, 3], Sqrt[3] r[2, 3], Sqrt[3] r[3, 3]} == {Sqrt[2], -Sqrt[-], -(-------)}, 
                                                                        3     Sqrt[3]
                            2            r[1, 3]
 {-(Sqrt[2] r[1, 1]) - Sqrt[-] r[1, 2] - -------, 
                            3            Sqrt[3]
                           2            r[2, 3]
 -(Sqrt[2] r[2, 1]) - Sqrt[-] r[2, 2] - -------, 
                           3            Sqrt[3]
                           2            r[3, 3]                      2        1
 -(Sqrt[2] r[3, 1]) - Sqrt[-] r[3, 2] - -------} == {-Sqrt[2], -Sqrt[-], -(-------)}, 
                           3            Sqrt[3]                      3     Sqrt[3]
                         2            r[1, 3]                         2            r[2, 3]
 {Sqrt[2] r[1, 1] - Sqrt[-] r[1, 2] - -------, Sqrt[2] r[2, 1] - Sqrt[-] r[2, 2] - -------, 
                         3            Sqrt[3]                         3            Sqrt[3]
                        2            r[3, 3]                2        1
 Sqrt[2] r[3, 1] - Sqrt[-] r[3, 2] - -------} == {0, 2 Sqrt[-], -(-------)}}
                        3            Sqrt[3]                3     Sqrt[3]
:[font = input; preserveAspect; startGroup]
r2=R/.Solve[sys,Flatten[R]]//First//Simplify

:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
{{1/2, 1/(2*3^(1/2)), (2/3)^(1/2)}, {3^(1/2)/2, -1/6, -2^(1/2)/3}, {0, (2*2^(1/2))/3, -1/3}}
;[o]
  1      1           2     Sqrt[3]    1   -Sqrt[2]       2 Sqrt[2]    1
{{-, ---------, Sqrt[-]}, {-------, -(-), --------}, {0, ---------, -(-)}}
  2  2 Sqrt[3]       3        2       6      3               3        3
:[font = input; preserveAspect; startGroup]
compare[object,r2]
:[font = output; output; inactive; preserveAspect; endGroup]
GraphicsArray["<<>>"]
;[o]
-GraphicsArray-
:[font = text; inactive; preserveAspect]
This is the rotation matrix that we are looking for.  It would be nice to know what the values of phi, theta and psi that produce r2.  We leave that as an exercise.  
;[s]
3:0,0;130,1;132,0;167,-1;
2:2,13,9,Times,0,12,0,0,0;1,13,10,Courier,1,12,0,0,0;
:[font = text; inactive; preserveAspect]
Now that we have two distinct rotations of the tetrahedron, we might be able to generate a larger group.
:[font = input; preserveAspect; startGroup]
g2=GenerateGroupoid[{r1,r2},Simplify[#1.#2]&];
Order[g2]
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
12
;[o]
12
:[font = text; inactive; preserveAspect]
This should be the whole group that we are searching for.  Now to demonstrate how the group generates all rotations, we will start with a single marked face of the tetrahedron. 
:[font = input; preserveAspect]
markedface=object[[2]]//
           {#,
            RGBColor[0.022, 0.688, 0.717],
            Thickness[0.01],
            Line[{Apply[Plus,object[[2,1]]]/3, 1.1 #[[1,1]]}],
            RGBColor[0.701, 0.038, 0.038],
            PointSize[0.03],
            Point[1.1 #[[1,1]]]}&//disp;
:[font = text; inactive; preserveAspect]
First we will look at the individual effects of each group element on this face.
:[font = input; preserveAspect; startGroup]
Map[ActionOn[markedface,#]&,First[g2]]//
         Partition[#,4]&//
         GraphicsArray//Show
:[font = output; output; inactive; preserveAspect; endGroup]
GraphicsArray["<<>>"]
;[o]
-GraphicsArray-
:[font = text; inactive; preserveAspect]
Taken together, we get a single tetrahedron. 
:[font = input; preserveAspect; startGroup]
Map[ActionOn[markedface,#]&,First[g2]]//Show

:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup; endGroup]
Graphics3D["<<>>"]
;[o]
-Graphics3D-
:[font = section; inactive; preserveAspect; startGroup]
Exercises
:[font = subsection; inactive; preserveAspect; startGroup]
1
:[font = text; inactive; preserveAspect]
(a)  How many element would you expect to find in the group of rotations of the cube?
(b)  Generate the group of rotations of the cube that is contained in the Polyhedra package, Cube[].  
;[s]
3:0,0;178,1;185,0;189,-1;
2:2,13,9,Times,0,12,0,0,0;1,13,10,Courier,1,12,0,0,0;
:[font = input; preserveAspect; endGroup]
Cube[]//disp;
:[font = subsection; inactive; preserveAspect; startGroup]
2
:[font = text; inactive; preserveAspect]
(a)  How many element would you expect to find in the group of rotations of the dodecahedron?
(b)  Generate the group of rotations of the dodecahedron that is contained in the Polyhedra package, Dodecahedron[].  
;[s]
3:0,0;194,1;209,0;213,-1;
2:2,13,9,Times,0,12,0,0,0;1,13,10,Courier,1,12,0,0,0;
:[font = input; preserveAspect; endGroup]
Dodecahedron[]//disp;
:[font = subsection; inactive; preserveAspect; startGroup]
3.  Rotational Groups of the Octahedron and Icosahedron.
:[font = text; inactive; preserveAspect; endGroup]
The octahedron is the dual of the cube.   If each face of the cube is replaced with a point at its center and points that are derived from adjacent faces are connected then the wire frame of an octahedron will appear.  Explain why the roational group of the octahedron should be isomorphic to that of the cube.  The dodecahedron and icosahedron pair up in the same way.
:[font = subsection; inactive; preserveAspect; startGroup]
4.  The cuboctahedron
:[font = input; preserveAspect; startGroup]
?Truncate
:[font = print; inactive; preserveAspect; endGroup]
Truncate[expr] truncates each edge of each polygon in expr. Truncate[expr, ratio] truncates to
  the specified ratio of the edge length.
:[font = input; preserveAspect; startGroup]
Cube[]
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
{Polygon[{{0.7071067811865475, 0.7071067811865475, 0.7071067811865475}, 
 {-0.7071067811865475, 0.7071067811865475, 0.7071067811865475}, 
 {-0.7071067811865475, -0.7071067811865475, 0.7071067811865475}, 
 {0.7071067811865475, -0.7071067811865475, 0.7071067811865475}}], 
 Polygon[{{0.7071067811865475, 0.7071067811865475, 0.7071067811865475}, 
 {0.7071067811865475, -0.7071067811865475, 0.7071067811865475}, 
 {0.7071067811865475, -0.7071067811865475, -0.7071067811865475}, 
 {0.7071067811865475, 0.7071067811865475, -0.7071067811865475}}], 
 Polygon[{{0.7071067811865475, 0.7071067811865475, 0.7071067811865475}, 
 {0.7071067811865475, 0.7071067811865475, -0.7071067811865475}, 
 {-0.7071067811865475, 0.7071067811865475, -0.7071067811865475}, 
 {-0.7071067811865475, 0.7071067811865475, 0.7071067811865475}}], 
 Polygon[{{-0.7071067811865475, 0.7071067811865475, 0.7071067811865475}, 
 {-0.7071067811865475, 0.7071067811865475, -0.7071067811865475}, 
 {-0.7071067811865475, -0.7071067811865475, -0.7071067811865475}, 
 {-0.7071067811865475, -0.7071067811865475, 0.7071067811865475}}], 
 Polygon[{{-0.7071067811865475, -0.7071067811865475, -0.7071067811865475}, 
 {-0.7071067811865475, 0.7071067811865475, -0.7071067811865475}, 
 {0.7071067811865475, 0.7071067811865475, -0.7071067811865475}, 
 {0.7071067811865475, -0.7071067811865475, -0.7071067811865475}}], 
 Polygon[{{-0.7071067811865475, -0.7071067811865475, 0.7071067811865475}, 
 {-0.7071067811865475, -0.7071067811865475, -0.7071067811865475}, 
 {0.7071067811865475, -0.7071067811865475, -0.7071067811865475}, 
 {0.7071067811865475, -0.7071067811865475, 0.7071067811865475}}]}
;[o]
{Polygon[{{0.707107, 0.707107, 0.707107}, {-0.707107, 0.707107, 0.707107}, 
 {-0.707107, -0.707107, 0.707107}, {0.707107, -0.707107, 0.707107}}], 
 Polygon[{{0.707107, 0.707107, 0.707107}, {0.707107, -0.707107, 0.707107}, 
 {0.707107, -0.707107, -0.707107}, {0.707107, 0.707107, -0.707107}}], 
 Polygon[{{0.707107, 0.707107, 0.707107}, {0.707107, 0.707107, -0.707107}, 
 {-0.707107, 0.707107, -0.707107}, {-0.707107, 0.707107, 0.707107}}], 
 Polygon[{{-0.707107, 0.707107, 0.707107}, {-0.707107, 0.707107, -0.707107}, 
 {-0.707107, -0.707107, -0.707107}, {-0.707107, -0.707107, 0.707107}}], 
 Polygon[{{-0.707107, -0.707107, -0.707107}, {-0.707107, 0.707107, -0.707107}, 
 {0.707107, 0.707107, -0.707107}, {0.707107, -0.707107, -0.707107}}], 
 Polygon[{{-0.707107, -0.707107, 0.707107}, {-0.707107, -0.707107, -0.707107}, 
 {0.707107, -0.707107, -0.707107}, {0.707107, -0.707107, 0.707107}}]}
:[font = input; preserveAspect; startGroup]
Truncate[Tetrahedron[],0.48]
:[font = message; inactive; preserveAspect]
Join::heads: Heads Polygon and List at positions 1 and 2 are expected to be the same.
:[font = message; inactive; preserveAspect]
Join::heads: Heads Graphics3D and List at positions 1 and 2 are expected to be the same.
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup; endGroup]
Join[Graphics3D["<<>>"], {Polygon[{{-0.6788225099390857, -0.3919183588453085, 
 0.6235382907247958}, {-0.7353910524340095, -0.4245782220824176, 0.5311622476544553}, 
 {-0.05656854249492383, -0.816496580927726, -0.5773502691896259}, 
 {0.05656854249492383, -0.816496580927726, -0.5773502691896259}, 
 {0.7353910524340095, -0.4245782220824176, 0.5311622476544554}, 
 {0.6788225099390857, -0.3919183588453085, 0.6235382907247958}}], 
 Polygon[{{0.6788225099390857, -0.3919183588453085, 0.6235382907247958}, 
 {0.7353910524340095, -0.4245782220824176, 0.5311622476544553}, 
 {0.7353910524340095, 0.3592584956081994, -0.5773502691896259}, 
 {0.6788225099390857, 0.4572380853195268, -0.5773502691896259}, 
 {0., 0.849156444164835, 0.5311622476544554}, {0., 0.7838367176906171, 0.6235382907247958}}],
 Polygon[{{0.6788225099390857, 0.4572380853195268, -0.5773502691896259}, 
 {0.7353910524340095, 0.3592584956081994, -0.5773502691896259}, 
 {0.05656854249492383, -0.816496580927726, -0.5773502691896259}, 
 {-0.05656854249492383, -0.816496580927726, -0.5773502691896259}, 
 {-0.7353910524340095, 0.3592584956081994, -0.5773502691896259}, 
 {-0.6788225099390857, 0.4572380853195268, -0.5773502691896259}}]}]
;[o]
Join[-Graphics3D-, {Polygon[{{-0.678823, -0.391918, 0.623538}, 
 {-0.735391, -0.424578, 0.531162}, {-0.0565685, -0.816497, -0.57735}, 
 {0.0565685, -0.816497, -0.57735}, {0.735391, -0.424578, 0.531162}, 
 {0.678823, -0.391918, 0.623538}}], Polygon[{{0.678823, -0.391918, 0.623538}, 
 {0.735391, -0.424578, 0.531162}, {0.735391, 0.359258, -0.57735}, 
 {0.678823, 0.457238, -0.57735}, {0., 0.849156, 0.531162}, {0., 0.783837, 0.623538}}], 
 Polygon[{{0.678823, 0.457238, -0.57735}, {0.735391, 0.359258, -0.57735}, 
 {0.0565685, -0.816497, -0.57735}, {-0.0565685, -0.816497, -0.57735}, 
 {-0.735391, 0.359258, -0.57735}, {-0.678823, 0.457238, -0.57735}}]}]
:[font = subsection; inactive; preserveAspect; startGroup]
5
:[font = text; inactive; preserveAspect]
Determine the values of phi, theta and psi for which RotationMatrix3D[phi, theta, psi] is equal to r2.   Hint:  To equate two matrices, A and B,  and convert to a list of equations, you can use code something like  (A==B)//Thread[#]&//Map[Thread[#]&,#]&//Flatten
;[s]
6:0,0;53,1;86,0;99,1;101,0;215,1;263,-1;
2:3,13,9,Times,0,12,0,0,0;3,13,10,Courier,1,12,0,0,0;
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
solution
:[font = input; preserveAspect; startGroup]

Clear[phi,theta,psi]
sys2=(RotationMatrix3D[phi,theta,psi]==r2)//Thread[#]&//Map[Thread[#]&,#]&//Flatten
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
{Cos[a]*Cos[c] - Cos[b]*Sin[a]*Sin[c] == 1/2, 
 Cos[c]*Sin[a] + Cos[a]*Cos[b]*Sin[c] == 1/(2*3^(1/2)), Sin[b]*Sin[c] == (2/3)^(1/2), 
 -(Cos[b]*Cos[c]*Sin[a]) - Cos[a]*Sin[c] == 3^(1/2)/2, 
 Cos[a]*Cos[b]*Cos[c] - Sin[a]*Sin[c] == -1/6, Cos[c]*Sin[b] == -2^(1/2)/3, 
 Sin[a]*Sin[b] == 0, -(Cos[a]*Sin[b]) == (2*2^(1/2))/3, Cos[b] == -1/3}
;[o]
                                         1
{Cos[a] Cos[c] - Cos[b] Sin[a] Sin[c] == -, 
                                         2
                                             1                            2
 Cos[c] Sin[a] + Cos[a] Cos[b] Sin[c] == ---------, Sin[b] Sin[c] == Sqrt[-], 
                                         2 Sqrt[3]                        3
                                            Sqrt[3]
 -(Cos[b] Cos[c] Sin[a]) - Cos[a] Sin[c] == -------, 
                                               2
                                           1                    -Sqrt[2]
 Cos[a] Cos[b] Cos[c] - Sin[a] Sin[c] == -(-), Cos[c] Sin[b] == --------, Sin[a] Sin[b] == 0, 
                                           6                       3
                     2 Sqrt[2]              1
 -(Cos[a] Sin[b]) == ---------, Cos[b] == -(-)}
                         3                  3
:[font = text; inactive; preserveAspect]
From the last equation, it is clear what theta must equal.
:[font = input; preserveAspect; startGroup]
theta=ArcCos[-1/3]
:[font = output; output; inactive; preserveAspect; endGroup]
ArcCos[-1/3]
;[o]
         1
ArcCos[-(-)]
         3
:[font = text; inactive; preserveAspect]
Now that theta is known, look at sys2.
;[s]
3:0,0;33,1;37,0;39,-1;
2:2,13,9,Times,0,12,0,0,0;1,13,10,Courier,1,12,0,0,0;
:[font = input; preserveAspect; startGroup]
sys2//Simplify
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
{Cos[a]*Cos[c] + (Sin[a]*Sin[c])/3 == 1/2, 
 Cos[c]*Sin[a] - (Cos[a]*Sin[c])/3 == 1/(2*3^(1/2)), (2*2^(1/2)*Sin[c])/3 == (2/3)^(1/2), 
 (Cos[c]*Sin[a])/3 - Cos[a]*Sin[c] == 3^(1/2)/2, -(Cos[a]*Cos[c])/3 - Sin[a]*Sin[c] == -1/6, 
 (2*2^(1/2)*Cos[c])/3 == -2^(1/2)/3, (2*2^(1/2)*Sin[a])/3 == 0, 
 (-2*2^(1/2)*Cos[a])/3 == (2*2^(1/2))/3, True}
;[o]
                 Sin[a] Sin[c]    1                  Cos[a] Sin[c]        1
{Cos[a] Cos[c] + ------------- == -, Cos[c] Sin[a] - ------------- == ---------, 
                       3          2                        3          2 Sqrt[3]
 2 Sqrt[2] Sin[c]         2   Cos[c] Sin[a]                    Sqrt[3]
 ---------------- == Sqrt[-], ------------- - Cos[a] Sin[c] == -------, 
        3                 3         3                             2
 -(Cos[a] Cos[c])                      1   2 Sqrt[2] Cos[c]    -Sqrt[2]
 ---------------- - Sin[a] Sin[c] == -(-), ---------------- == --------, 
        3                              6          3               3
 2 Sqrt[2] Sin[a]       -2 Sqrt[2] Cos[a]    2 Sqrt[2]
 ---------------- == 0, ----------------- == ---------, True}
        3                       3                3
:[font = text; inactive; preserveAspect]
The eight equations involves only phi at this point.
;[s]
3:0,0;34,1;37,0;53,-1;
2:2,13,9,Times,0,12,0,0,0;1,13,10,Courier,1,12,0,0,0;
:[font = input; preserveAspect; startGroup]
Solve[sys2[[8]],Cos[phi]]
:[font = output; output; inactive; preserveAspect; endGroup]
{{Cos[a] -> -1}}
;[o]
{{Cos[a] -> -1}}
:[font = input; preserveAspect; startGroup]
phi=ArcCos[-1]
:[font = output; output; inactive; preserveAspect; endGroup]
Pi
;[o]
Pi
:[font = input; preserveAspect; startGroup]
sys2
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
{-Cos[c] == 1/2, Sin[c]/3 == 1/(2*3^(1/2)), (2*2^(1/2)*Sin[c])/3 == (2/3)^(1/2), 
 Sin[c] == 3^(1/2)/2, Cos[c]/3 == -1/6, (2*2^(1/2)*Cos[c])/3 == -2^(1/2)/3, True, True, True}
;[o]
            1  Sin[c]        1      2 Sqrt[2] Sin[c]         2             Sqrt[3]
{-Cos[c] == -, ------ == ---------, ---------------- == Sqrt[-], Sin[c] == -------, 
            2    3       2 Sqrt[3]         3                 3                2
 Cos[c]      1   2 Sqrt[2] Cos[c]    -Sqrt[2]
 ------ == -(-), ---------------- == --------, True, True, True}
   3         6          3               3
:[font = input; preserveAspect; startGroup]
psi=ArcCos[-1/2]
:[font = output; output; inactive; preserveAspect; endGroup]
(2*Pi)/3
;[o]
2 Pi
----
 3
:[font = input; preserveAspect; startGroup]
sys2
:[font = output; output; inactive; preserveAspect; endGroup]
{True, True, True, True, True, True, True, True, True}
;[o]
{True, True, True, True, True, True, True, True, True}
:[font = input; preserveAspect; startGroup]
{phi,theta,psi}
:[font = output; output; inactive; preserveAspect; endGroup; endGroup; endGroup]
{Pi, ArcCos[-1/3], (2*Pi)/3}
;[o]
              1    2 Pi
{Pi, ArcCos[-(-)], ----}
              3     3
:[font = subsection; inactive; preserveAspect; startGroup]
6. Why should the method of finding rotation matrices used above work?
:[font = text; inactive; preserveAspect; endGroup; endGroup]
Let T be a triangle in three dimensional real space whose veritices are linearly independent.   Prove that if R is a three by three matrix with the property that the triangle R.T is congruent to T then R is a rotation matrix.
^*)
